#include <sourcemod>
#include <sdktools>
#include <customguns>

#pragma semicolon 1
#pragma newdecls required


public Plugin myinfo = 
{
	name = "medkit custom weapon",
	author = "superhalflifekid",
	version = "1.0"
};

public void CG_OnPrimaryAttack(int client, int weapon)
{
	char sWeapon[32];
	GetEntityClassname(weapon, sWeapon, sizeof(sWeapon));
	
	if(StrEqual(sWeapon, "weapon_medkit"))
	{
		CG_Cooldown(weapon, 2.5);
		
		float fEyeAngles[3];
		float fEyePos[3];
		
		
		
		GetClientEyePosition(client, fEyePos);
		GetClientEyeAngles(client, fEyeAngles);
		

		Handle hMedkitTrace = TR_TraceRayFilterEx(fEyePos, fEyeAngles, MASK_ALL, RayType_Infinite, TraceRayClientFilter, client);
		
		int iResult = TR_GetEntityIndex(hMedkitTrace);

		
		if (iResult > 0)
		{
			if (IsValidEntity(iResult))
			{
				char sClassname[64];
				GetEntityClassname(iResult, sClassname, sizeof(sClassname));
				
				
				if (StrEqual(sClassname, "player"))
				{
					if (IsClientConnected(iResult) || IsFakeClient(iResult))
					{
						float fEndPos[3];
						TR_GetEndPosition(fEndPos, hMedkitTrace);
						
						float fDistance = GetVectorDistance(fEndPos, fEyePos, false);
						
						
						if (fDistance < 64.0)
						{
							int iClientHealth = GetEntProp(iResult, Prop_Data, "m_iHealth");
							
							if (iClientHealth < 100)
							{
								CG_PlayActivity(weapon, ACT_VM_HAULBACK);
								
								
								
								if (iClientHealth + 20 >= 100)
								{
									SetEntityHealth(iResult, 100);
								}
								else
								{
									SetEntityHealth(iResult, iClientHealth + 20);
								}
								
								EmitGameSoundToAll("HealthKit.Touch", weapon);
								
							}
						}
					}
				}
			}
		}
		
		
		CloseHandle(hMedkitTrace);
		
	}
}



public void CG_OnSecondaryAttack(int client, int weapon)
{
	char sWeapon[32];
	GetEntityClassname(weapon, sWeapon, sizeof(sWeapon));
	
	if(StrEqual(sWeapon, "weapon_medkit"))
	{
		CG_Cooldown(weapon, 2.3);
		
		if (IsValidEntity(client))
		{
			if (IsClientConnected(client))
			{
				int iClientHealth = GetEntProp(client, Prop_Data, "m_iHealth");
							
				if (iClientHealth < 100)
				{	
					CG_PlayActivity(weapon, ACT_VM_HAULBACK);
								
								
								
					if (iClientHealth + 20 >= 100)
					{
						SetEntityHealth(client, 100);
					}
					else
					{
						SetEntityHealth(client, iClientHealth + 20);
					}
								
					EmitGameSoundToAll("HealthKit.Touch", weapon);		
				}
				
				
				
			}
		}
	}
}


//Trace ray does not hit firing client
public bool TraceRayClientFilter(int entity, int contentsMask, any data)
{
	return (entity != data) ? true : false;
}